using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net;

using nsAlienRFID2;

namespace TCPListenerEx9
{
    public partial class Form1 : Form
    {
        CAlienServer mServer;
        private delegate void showMsg();
        bool mbDisposing = false;
        
        public Form1()
        {
            InitializeComponent();
            AlienLog.Path = "C:\\";
        }

        private void btnListen_Click(object sender, EventArgs e)
        {
            
            if ((mServer != null) && (mServer.IsListening))
            {
                this.Cursor = Cursors.WaitCursor;

                btnListen.Text = "Start Listening";
                mServer.StopListening();
                mServer.ServerMessageReceived -= new CAlienServer.ServerMessageReceivedEventHandler(mServer_ServerMessageReceived);
                System.Threading.Thread.Sleep(1);
                this.Cursor = Cursors.Default;
                return;
            }



            IPAddress ipAddress;
            int port;
            if (!IPAddress.TryParse(txtAddress.Text.Trim(), out ipAddress))
            {
                MessageBox.Show("Bad IPAddress");
                txtAddress.SelectAll();
                txtAddress.Focus();
                return;
            }
            else if (!int.TryParse(txtPort.Text.Trim(), out port) || (port == 0))
            {
                MessageBox.Show("Bad network port");
                txtPort.SelectAll();
                txtPort.Focus();
                return;
            }

            this.Cursor = Cursors.WaitCursor;

            mServer = new CAlienServer(port, ipAddress.ToString(), true);
            mServer.ServerMessageReceived += new CAlienServer.ServerMessageReceivedEventHandler(mServer_ServerMessageReceived);
            try
            {
                mServer.StopListening(); 
                mServer.StartListening();
                btnListen.Text = "Stop Listening";
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
                mServer.Dispose();
                mServer = null;
            }

            this.Cursor = Cursors.Default;
        }

        void mServer_ServerMessageReceived(string msg)
        {
            if ((mbDisposing) || (msg == null))
                return;

            lock (this)
            {
                showMsg method = delegate
                {
                    string s = removePrefix(msg);
                    txtMessages.AppendText(s.Replace("\r\n", "[\\r\\n]").Replace("\0", "[\\0]") + "\r\n");
                };
                this.BeginInvoke(method);
            }
        }

        string removePrefix(string msg)
        {
            if (msg == null)
                return null;

            int idx = msg.IndexOf(" ");
            if ((idx == -1) || ( idx == msg.Length))
                return msg;
            else
                return msg.Substring(idx + 1);
        }


        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if ((mServer != null) && (mServer.IsListening))
            {
                mbDisposing = true;
                try { mServer.StopListening(); }
                catch { }
            }
        }
    }
}